!function(name,definition){if(typeof module!='undefined'&&module.exports)module.exports=definition()
else if(typeof define=='function'&&define.amd)define(name,definition)
else this[name]=definition()}('bowser',function(){var t=true
function detect(ua){function getFirstMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[1])||'';}
function getSecondMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[2])||'';}
var iosdevice=getFirstMatch(/(ipod|iphone|ipad)/i).toLowerCase(),likeAndroid=/like android/i.test(ua),android=!likeAndroid&&/android/i.test(ua),nexusMobile=/nexus\s*[0-6]\s*/i.test(ua),nexusTablet=!nexusMobile&&/nexus\s*[0-9]+/i.test(ua),chromeos=/CrOS/.test(ua),silk=/silk/i.test(ua),sailfish=/sailfish/i.test(ua),tizen=/tizen/i.test(ua),webos=/(web|hpw)os/i.test(ua),windowsphone=/windows phone/i.test(ua),windows=!windowsphone&&/windows/i.test(ua),mac=!iosdevice&&!silk&&/macintosh/i.test(ua),linux=!android&&!sailfish&&!tizen&&!webos&&/linux/i.test(ua),edgeVersion=getFirstMatch(/edge\/(\d+(\.\d+)?)/i),versionIdentifier=getFirstMatch(/version\/(\d+(\.\d+)?)/i),tablet=/tablet/i.test(ua),mobile=!tablet&&/[^-]mobi/i.test(ua),xbox=/xbox/i.test(ua),result
if(/opera|opr|opios/i.test(ua)){result={name:'Opera',opera:t,version:versionIdentifier||getFirstMatch(/(?:opera|opr|opios)[\s\/](\d+(\.\d+)?)/i)}}
else if(/coast/i.test(ua)){result={name:'Opera Coast',coast:t,version:versionIdentifier||getFirstMatch(/(?:coast)[\s\/](\d+(\.\d+)?)/i)}}
else if(/yabrowser/i.test(ua)){result={name:'Yandex Browser',yandexbrowser:t,version:versionIdentifier||getFirstMatch(/(?:yabrowser)[\s\/](\d+(\.\d+)?)/i)}}
else if(/ucbrowser/i.test(ua)){result={name:'UC Browser',ucbrowser:t,version:getFirstMatch(/(?:ucbrowser)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/mxios/i.test(ua)){result={name:'Maxthon',maxthon:t,version:getFirstMatch(/(?:mxios)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/epiphany/i.test(ua)){result={name:'Epiphany',epiphany:t,version:getFirstMatch(/(?:epiphany)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/puffin/i.test(ua)){result={name:'Puffin',puffin:t,version:getFirstMatch(/(?:puffin)[\s\/](\d+(?:\.\d+)?)/i)}}
else if(/sleipnir/i.test(ua)){result={name:'Sleipnir',sleipnir:t,version:getFirstMatch(/(?:sleipnir)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/k-meleon/i.test(ua)){result={name:'K-Meleon',kMeleon:t,version:getFirstMatch(/(?:k-meleon)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(windowsphone){result={name:'Windows Phone',windowsphone:t}
if(edgeVersion){result.msedge=t
result.version=edgeVersion}
else{result.msie=t
result.version=getFirstMatch(/iemobile\/(\d+(\.\d+)?)/i)}}
else if(/msie|trident/i.test(ua)){result={name:'Internet Explorer',msie:t,version:getFirstMatch(/(?:msie |rv:)(\d+(\.\d+)?)/i)}}else if(chromeos){result={name:'Chrome',chromeos:t,chromeBook:t,chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}else if(/chrome.+? edge/i.test(ua)){result={name:'Microsoft Edge',msedge:t,version:edgeVersion}}
else if(/vivaldi/i.test(ua)){result={name:'Vivaldi',vivaldi:t,version:getFirstMatch(/vivaldi\/(\d+(\.\d+)?)/i)||versionIdentifier}}
else if(sailfish){result={name:'Sailfish',sailfish:t,version:getFirstMatch(/sailfish\s?browser\/(\d+(\.\d+)?)/i)}}
else if(/seamonkey\//i.test(ua)){result={name:'SeaMonkey',seamonkey:t,version:getFirstMatch(/seamonkey\/(\d+(\.\d+)?)/i)}}
else if(/firefox|iceweasel|fxios/i.test(ua)){result={name:'Firefox',firefox:t,version:getFirstMatch(/(?:firefox|iceweasel|fxios)[ \/](\d+(\.\d+)?)/i)}
if(/\((mobile|tablet);[^\)]*rv:[\d\.]+\)/i.test(ua)){result.firefoxos=t}}
else if(silk){result={name:'Amazon Silk',silk:t,version:getFirstMatch(/silk\/(\d+(\.\d+)?)/i)}}
else if(/phantom/i.test(ua)){result={name:'PhantomJS',phantom:t,version:getFirstMatch(/phantomjs\/(\d+(\.\d+)?)/i)}}
else if(/slimerjs/i.test(ua)){result={name:'SlimerJS',slimer:t,version:getFirstMatch(/slimerjs\/(\d+(\.\d+)?)/i)}}
else if(/blackberry|\bbb\d+/i.test(ua)||/rim\stablet/i.test(ua)){result={name:'BlackBerry',blackberry:t,version:versionIdentifier||getFirstMatch(/blackberry[\d]+\/(\d+(\.\d+)?)/i)}}
else if(webos){result={name:'WebOS',webos:t,version:versionIdentifier||getFirstMatch(/w(?:eb)?osbrowser\/(\d+(\.\d+)?)/i)};if(/touchpad\//i.test(ua)){result.touchpad=t;}}
else if(/bada/i.test(ua)){result={name:'Bada',bada:t,version:getFirstMatch(/dolfin\/(\d+(\.\d+)?)/i)};}
else if(tizen){result={name:'Tizen',tizen:t,version:getFirstMatch(/(?:tizen\s?)?browser\/(\d+(\.\d+)?)/i)||versionIdentifier};}
else if(/qupzilla/i.test(ua)){result={name:'QupZilla',qupzilla:t,version:getFirstMatch(/(?:qupzilla)[\s\/](\d+(?:\.\d+)+)/i)||versionIdentifier}}
else if(/chromium/i.test(ua)){result={name:'Chromium',chromium:t,version:getFirstMatch(/(?:chromium)[\s\/](\d+(?:\.\d+)?)/i)||versionIdentifier}}
else if(/chrome|crios|crmo/i.test(ua)){result={name:'Chrome',chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}
else if(android){result={name:'Android',version:versionIdentifier}}
else if(/safari|applewebkit/i.test(ua)){result={name:'Safari',safari:t}
if(versionIdentifier){result.version=versionIdentifier}}
else if(iosdevice){result={name:iosdevice=='iphone'?'iPhone':iosdevice=='ipad'?'iPad':'iPod'}
if(versionIdentifier){result.version=versionIdentifier}}
else if(/googlebot/i.test(ua)){result={name:'Googlebot',googlebot:t,version:getFirstMatch(/googlebot\/(\d+(\.\d+))/i)||versionIdentifier}}
else{result={name:getFirstMatch(/^(.*)\/(.*) /),version:getSecondMatch(/^(.*)\/(.*) /)};}
if(!result.msedge&&/(apple)?webkit/i.test(ua)){if(/(apple)?webkit\/537\.36/i.test(ua)){result.name=result.name||"Blink"
result.blink=t}else{result.name=result.name||"Webkit"
result.webkit=t}
if(!result.version&&versionIdentifier){result.version=versionIdentifier}}else if(!result.opera&&/gecko\//i.test(ua)){result.name=result.name||"Gecko"
result.gecko=t
result.version=result.version||getFirstMatch(/gecko\/(\d+(\.\d+)?)/i)}
if(!result.msedge&&(android||result.silk)){result.android=t}else if(iosdevice){result[iosdevice]=t
result.ios=t}else if(mac){result.mac=t}else if(xbox){result.xbox=t}else if(windows){result.windows=t}else if(linux){result.linux=t}
var osVersion='';if(result.windowsphone){osVersion=getFirstMatch(/windows phone (?:os)?\s?(\d+(\.\d+)*)/i);}else if(iosdevice){osVersion=getFirstMatch(/os (\d+([_\s]\d+)*) like mac os x/i);osVersion=osVersion.replace(/[_\s]/g,'.');}else if(android){osVersion=getFirstMatch(/android[ \/-](\d+(\.\d+)*)/i);}else if(result.webos){osVersion=getFirstMatch(/(?:web|hpw)os\/(\d+(\.\d+)*)/i);}else if(result.blackberry){osVersion=getFirstMatch(/rim\stablet\sos\s(\d+(\.\d+)*)/i);}else if(result.bada){osVersion=getFirstMatch(/bada\/(\d+(\.\d+)*)/i);}else if(result.tizen){osVersion=getFirstMatch(/tizen[\/\s](\d+(\.\d+)*)/i);}
if(osVersion){result.osversion=osVersion;}
var osMajorVersion=osVersion.split('.')[0];if(tablet||nexusTablet||iosdevice=='ipad'||(android&&(osMajorVersion==3||(osMajorVersion>=4&&!mobile)))||result.silk){result.tablet=t}else if(mobile||iosdevice=='iphone'||iosdevice=='ipod'||android||nexusMobile||result.blackberry||result.webos||result.bada){result.mobile=t}
if(result.msedge||(result.msie&&result.version>=10)||(result.yandexbrowser&&result.version>=15)||(result.vivaldi&&result.version>=1.0)||(result.chrome&&result.version>=20)||(result.firefox&&result.version>=20.0)||(result.safari&&result.version>=6)||(result.opera&&result.version>=10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]>=6)||(result.blackberry&&result.version>=10.1)||(result.chromium&&result.version>=20)){result.a=t;}
else if((result.msie&&result.version<10)||(result.chrome&&result.version<20)||(result.firefox&&result.version<20.0)||(result.safari&&result.version<6)||(result.opera&&result.version<10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]<6)||(result.chromium&&result.version<20)){result.c=t}else result.x=t
return result}
var bowser=detect(typeof navigator!=='undefined'?navigator.userAgent:'')
bowser.test=function(browserList){for(var i=0;i<browserList.length;++i){var browserItem=browserList[i];if(typeof browserItem==='string'){if(browserItem in bowser){return true;}}}
return false;}
function getVersionPrecision(version){return version.split(".").length;}
function map(arr,iterator){var result=[],i;if(Array.prototype.map){return Array.prototype.map.call(arr,iterator);}
for(i=0;i<arr.length;i++){result.push(iterator(arr[i]));}
return result;}
function compareVersions(versions){var precision=Math.max(getVersionPrecision(versions[0]),getVersionPrecision(versions[1]));var chunks=map(versions,function(version){var delta=precision-getVersionPrecision(version);version=version+new Array(delta+1).join(".0");return map(version.split("."),function(chunk){return new Array(20-chunk.length).join("0")+chunk;}).reverse();});while(--precision>=0){if(chunks[0][precision]>chunks[1][precision]){return 1;}
else if(chunks[0][precision]===chunks[1][precision]){if(precision===0){return 0;}}
else{return-1;}}}
function isUnsupportedBrowser(minVersions,strictMode,ua){var _bowser=bowser;if(typeof strictMode==='string'){ua=strictMode;strictMode=void(0);}
if(strictMode===void(0)){strictMode=false;}
if(ua){_bowser=detect(ua);}
var version=""+_bowser.version;for(var browser in minVersions){if(minVersions.hasOwnProperty(browser)){if(_bowser[browser]){return compareVersions([version,minVersions[browser]])<0;}}}
return strictMode;}
function check(minVersions,strictMode,ua){return!isUnsupportedBrowser(minVersions,strictMode,ua);}
bowser.isUnsupportedBrowser=isUnsupportedBrowser;bowser.compareVersions=compareVersions;bowser.check=check;bowser._detect=detect;return bowser});(function($){UABBTrigger={triggerHook:function(hook,args)
{$('body').trigger('uabb-trigger.'+hook,args);},addHook:function(hook,callback)
{$('body').on('uabb-trigger.'+hook,callback);},removeHook:function(hook,callback)
{$('body').off('uabb-trigger.'+hook,callback);},};})(jQuery);jQuery(document).ready(function($){if(typeof bowser!=='undefined'&&bowser!==null){var uabb_browser=bowser.name,uabb_browser_v=bowser.version,uabb_browser_class=uabb_browser.replace(/\s+/g,'-').toLowerCase(),uabb_browser_v_class=uabb_browser_class+parseInt(uabb_browser_v);$('html').addClass(uabb_browser_class).addClass(uabb_browser_v_class);}
$('.uabb-row-separator').parents('html').css('overflow-x','hidden');});var wpAjaxUrl='https://fenixingenieria.es/wp-admin/admin-ajax.php';var flBuilderUrl='https://fenixingenieria.es/wp-content/plugins/beaver-builder-lite-version/';var FLBuilderLayoutConfig={anchorLinkAnimations:{duration:1000,easing:'swing',offset:100},paths:{pluginUrl:'https://fenixingenieria.es/wp-content/plugins/beaver-builder-lite-version/',wpAjaxUrl:'https://fenixingenieria.es/wp-admin/admin-ajax.php'},breakpoints:{small:768,medium:992},waypoint:{offset:80}};(function($){if(typeof FLBuilderLayout!='undefined'){return;}
FLBuilderLayout={init:function()
{FLBuilderLayout._destroy();FLBuilderLayout._initClasses();FLBuilderLayout._initBackgrounds();if(0===$('.fl-builder-edit').length){FLBuilderLayout._initModuleAnimations();FLBuilderLayout._initAnchorLinks();FLBuilderLayout._initHash();FLBuilderLayout._initForms();}},refreshGalleries:function(element)
{var $element='undefined'==typeof element?$('body'):$(element),mfContent=$element.find('.fl-mosaicflow-content'),wmContent=$element.find('.fl-gallery'),mfObject=null;if(mfContent){mfObject=mfContent.data('mosaicflow');if(mfObject){mfObject.columns=$([]);mfObject.columnsHeights=[];mfContent.data('mosaicflow',mfObject);mfContent.mosaicflow('refill');}}
if(wmContent){wmContent.trigger('refreshWookmark');}},refreshGridLayout:function(element)
{var $element='undefined'==typeof element?$('body'):$(element),msnryContent=$element.find('.masonry');if(msnryContent.length){msnryContent.masonry('layout');}},reloadSlider:function(element)
{var $element='undefined'==typeof element?$('body'):$(element),bxContent=$element.find('.bx-viewport > div').eq(0),bxObject=null;if(bxContent.length){bxObject=bxContent.data('bxSlider');if(bxObject){bxObject.reloadSlider();}}},resizeAudio:function(element)
{var $element='undefined'==typeof element?$('body'):$(element),audioPlayers=$element.find('.wp-audio-shortcode.mejs-audio'),player=null,mejsPlayer=null,rail=null,railWidth=400;if(audioPlayers.length&&typeof mejs!=='undefined'){audioPlayers.each(function(){player=$(this);mejsPlayer=mejs.players[player.attr('id')];rail=player.find('.mejs-controls .mejs-time-rail');var innerMejs=player.find('.mejs-inner'),total=player.find('.mejs-controls .mejs-time-total');if(typeof mejsPlayer!=='undefined'){railWidth=Math.ceil(player.width()*0.8);if(innerMejs.length){rail.css('width',railWidth+'px!important');mejsPlayer.options.autosizeProgress=true;setTimeout(function(){mejsPlayer.setControlsSize();},50);player.find('.mejs-inner').css({visibility:'visible',height:'inherit'});}}});}},preloadAudio:function(element)
{var $element='undefined'==typeof element?$('body'):$(element),contentWrap=$element.closest('.fl-accordion-item'),audioPlayers=$element.find('.wp-audio-shortcode.mejs-audio');if(!contentWrap.hasClass('fl-accordion-item-active')&&audioPlayers.find('.mejs-inner').length){audioPlayers.find('.mejs-inner').css({visibility:'hidden',height:0});}},resizeSlideshow:function(){if(typeof YUI!=='undefined'){YUI().use('node-event-simulate',function(Y){Y.one(window).simulate("resize");});}},reloadGoogleMap:function(element){var $element='undefined'==typeof element?$('body'):$(element),googleMap=$element.find('iframe[src*="google.com/maps"]');if(googleMap.length){googleMap.attr('src',function(i,val){return val;});}},_destroy:function()
{var win=$(window);win.off('scroll.fl-bg-parallax');win.off('resize.fl-bg-video');},_isTouch:function()
{if(('ontouchstart'in window)||(window.DocumentTouch&&document instanceof DocumentTouch)){return true;}
return false;},_isMobile:function()
{return/Mobile|Android|Silk\/|Kindle|BlackBerry|Opera Mini|Opera Mobi|webOS/i.test(navigator.userAgent);},_initClasses:function()
{var body=$('body'),ua=navigator.userAgent;if(!body.hasClass('archive')&&$('.fl-builder-content-primary').length>0){body.addClass('fl-builder');}
if(FLBuilderLayout._isTouch()){body.addClass('fl-builder-touch');}
if(FLBuilderLayout._isMobile()){body.addClass('fl-builder-mobile');}
if($(window).width()<FLBuilderLayoutConfig.breakpoints.small){body.addClass('fl-builder-breakpoint-small');}
if($(window).width()>FLBuilderLayoutConfig.breakpoints.small&&$(window).width()<FLBuilderLayoutConfig.breakpoints.medium){body.addClass('fl-builder-breakpoint-medium');}
if($(window).width()>FLBuilderLayoutConfig.breakpoints.medium){body.addClass('fl-builder-breakpoint-large');}
if(ua.indexOf('Trident/7.0')>-1&&ua.indexOf('rv:11.0')>-1){body.addClass('fl-builder-ie-11');}},_initBackgrounds:function()
{var win=$(window);if($('.fl-row-bg-parallax').length>0&&!FLBuilderLayout._isMobile()){FLBuilderLayout._scrollParallaxBackgrounds();FLBuilderLayout._initParallaxBackgrounds();win.on('scroll.fl-bg-parallax',FLBuilderLayout._scrollParallaxBackgrounds);}
if($('.fl-bg-video').length>0){FLBuilderLayout._initBgVideos();FLBuilderLayout._resizeBgVideos();win.on('resize.fl-bg-video',FLBuilderLayout._resizeBgVideos);}},_initParallaxBackgrounds:function()
{$('.fl-row-bg-parallax').each(FLBuilderLayout._initParallaxBackground);},_initParallaxBackground:function()
{var row=$(this),content=row.find('> .fl-row-content-wrap'),src=row.data('parallax-image'),loaded=row.data('parallax-loaded'),img=new Image();if(loaded){return;}
else if(typeof src!='undefined'){$(img).on('load',function(){content.css('background-image','url('+src+')');row.data('parallax-loaded',true);});img.src=src;}},_scrollParallaxBackgrounds:function()
{$('.fl-row-bg-parallax').each(FLBuilderLayout._scrollParallaxBackground);},_scrollParallaxBackground:function()
{var win=$(window),row=$(this),content=row.find('> .fl-row-content-wrap'),speed=row.data('parallax-speed'),offset=content.offset(),yPos=-((win.scrollTop()-offset.top)/speed);content.css('background-position','center '+yPos+'px');},_initBgVideos:function()
{$('.fl-bg-video').each(FLBuilderLayout._initBgVideo);},_initBgVideo:function()
{var wrap=$(this),width=wrap.data('width'),height=wrap.data('height'),mp4=wrap.data('mp4'),youtube=wrap.data('youtube'),vimeo=wrap.data('vimeo'),mp4Type=wrap.data('mp4-type'),webm=wrap.data('webm'),webmType=wrap.data('webm-type'),fallback=wrap.data('fallback'),loaded=wrap.data('loaded'),videoMobile=wrap.data('video-mobile'),fallbackTag='',videoTag=null,mp4Tag=null,webmTag=null;if(loaded){return;}
videoTag=$('<video autoplay loop muted playsinline></video>');if('undefined'!=typeof fallback&&''!=fallback){videoTag.attr('poster','data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7')
videoTag.css('background','transparent url("'+fallback+'") no-repeat center center')
videoTag.css('background-size','cover')
videoTag.css('height','100%')}
if('undefined'!=typeof mp4&&''!=mp4){mp4Tag=$('<source />');mp4Tag.attr('src',mp4);mp4Tag.attr('type',mp4Type);videoTag.append(mp4Tag);}
if('undefined'!=typeof webm&&''!=webm){webmTag=$('<source />');webmTag.attr('src',webm);webmTag.attr('type',webmType);videoTag.append(webmTag);}
if(!FLBuilderLayout._isMobile()||(FLBuilderLayout._isMobile()&&"yes"==videoMobile)){if('undefined'!=typeof youtube){FLBuilderLayout._initYoutubeBgVideo.apply(this);}
else if('undefined'!=typeof vimeo){FLBuilderLayout._initVimeoBgVideo.apply(this);}
else{wrap.append(videoTag);}}
else{videoTag.attr('src','')
wrap.append(videoTag);}
wrap.data('loaded',true);},_initYoutubeBgVideo:function()
{var playerWrap=$(this),videoId=playerWrap.data('video-id'),videoPlayer=playerWrap.find('.fl-bg-video-player'),enableAudio=playerWrap.data('enable-audio'),audioButton=playerWrap.find('.fl-bg-video-audio'),startTime='undefined'!==typeof playerWrap.data('start')?playerWrap.data('start'):0,endTime='undefined'!==typeof playerWrap.data('end')?playerWrap.data('end'):0,loop='undefined'!==typeof playerWrap.data('loop')?playerWrap.data('loop'):1,stateCount=0,player,fallback_showing;if(videoId){fallback=playerWrap.data('fallback')||false
if(fallback){playerWrap.find('iframe').remove()
fallbackTag=$('<div></div>');fallbackTag.addClass('fl-bg-video-fallback');fallbackTag.css('background-image','url('+playerWrap.data('fallback')+')');fallbackTag.css('background-size','cover');fallbackTag.css('transition','background-image 1s')
playerWrap.append(fallbackTag);fallback_showing=true;}
FLBuilderLayout._onYoutubeApiReady(function(YT){setTimeout(function(){player=new YT.Player(videoPlayer[0],{videoId:videoId,events:{onReady:function(event){if("no"===enableAudio||FLBuilderLayout._isMobile()){event.target.mute();}
else if("yes"===enableAudio&&event.target.isMuted){event.target.unMute();}
playerWrap.data('YTPlayer',player);FLBuilderLayout._resizeYoutubeBgVideo.apply(playerWrap);event.target.playVideo();if(audioButton.length>0&&!FLBuilderLayout._isMobile()){audioButton.on('click',{button:audioButton,player:player},FLBuilderLayout._toggleBgVideoAudio);}},onStateChange:function(event){if(event.data===1){if(fallback_showing){$('.fl-bg-video-fallback').css('background-image','url(data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7)')}}
if(stateCount<4){stateCount++;}
if(stateCount>1&&(-1===event.data||2===event.data)&&"yes"===enableAudio){player.mute();player.playVideo();audioButton.show();}
if(event.data===YT.PlayerState.ENDED&&1===loop){if(startTime>0){player.seekTo(startTime);}
else{player.playVideo();}}},onError:function(event){console.info('YT Error: '+event.data)
FLBuilderLayout._onErrorYoutubeVimeo(playerWrap)}},playerVars:{playsinline:FLBuilderLayout._isMobile()?1:0,controls:0,showinfo:0,rel:0,start:startTime,end:endTime,}});},1);});}},_onErrorYoutubeVimeo:function(playerWrap){fallback=playerWrap.data('fallback')||false
if(!fallback){return false;}
playerWrap.find('iframe').remove()
fallbackTag=$('<div></div>');fallbackTag.addClass('fl-bg-video-fallback');fallbackTag.css('background-image','url('+playerWrap.data('fallback')+')');playerWrap.append(fallbackTag);},_onYoutubeApiReady:function(callback){if(window.YT&&YT.loaded){callback(YT);}else{setTimeout(function(){FLBuilderLayout._onYoutubeApiReady(callback);},350);}},_initVimeoBgVideo:function()
{var playerWrap=$(this),videoId=playerWrap.data('video-id'),videoPlayer=playerWrap.find('.fl-bg-video-player'),enableAudio=playerWrap.data('enable-audio'),audioButton=playerWrap.find('.fl-bg-video-audio'),player,width=playerWrap.outerWidth(),ua=navigator.userAgent;if(typeof Vimeo!=='undefined'&&videoId){player=new Vimeo.Player(videoPlayer[0],{id:videoId,loop:true,title:false,portrait:false,background:true,autopause:false,muted:true});playerWrap.data('VMPlayer',player);if("no"===enableAudio){player.setVolume(0);}
else if("yes"===enableAudio){if(ua.indexOf("Safari")>-1||ua.indexOf("Chrome")>-1){player.setVolume(0);audioButton.show();}
else{player.setVolume(1);}}
player.play().catch(function(error){FLBuilderLayout._onErrorYoutubeVimeo(playerWrap)});if(audioButton.length>0){audioButton.on('click',{button:audioButton,player:player},FLBuilderLayout._toggleBgVideoAudio);}}},_toggleBgVideoAudio:function(e){var player=e.data.player,control=e.data.button.find('.fl-audio-control');if(control.hasClass('fa-volume-off')){control.removeClass('fa-volume-off').addClass('fa-volume-up');e.data.button.find('.fa-times').hide();if('function'===typeof player.unMute){player.unMute();}
else{player.setVolume(1);}}
else{control.removeClass('fa-volume-up').addClass('fa-volume-off');e.data.button.find('.fa-times').show();if('function'===typeof player.unMute){player.mute();}
else{player.setVolume(0);}}},_videoBgSourceError:function(e)
{var source=$(e.target),wrap=source.closest('.fl-bg-video'),vid=wrap.find('video'),fallback=wrap.data('fallback'),fallbackTag='';source.remove();if(vid.find('source').length){return;}else if(''!==fallback){fallbackTag=$('<div></div>');fallbackTag.addClass('fl-bg-video-fallback');fallbackTag.css('background-image','url('+fallback+')');wrap.append(fallbackTag);vid.remove();}},_resizeBgVideos:function()
{$('.fl-bg-video').each(function(){FLBuilderLayout._resizeBgVideo.apply(this);if($(this).parent().find('img').length>0){$(this).parent().imagesLoaded($.proxy(FLBuilderLayout._resizeBgVideo,this));}});},_resizeBgVideo:function()
{if(0===$(this).find('video').length&&0===$(this).find('iframe').length){return;}
var wrap=$(this),wrapHeight=wrap.outerHeight(),wrapWidth=wrap.outerWidth(),vid=wrap.find('video'),vidHeight=wrap.data('height'),vidWidth=wrap.data('width'),newWidth=wrapWidth,newHeight=Math.round(vidHeight*wrapWidth/vidWidth),newLeft=0,newTop=0,iframe=wrap.find('iframe');if(vid.length){if(vidHeight===''||typeof vidHeight==='undefined'||vidWidth===''||typeof vidWidth==='undefined'){vid.css({'left':'0px','top':'0px','width':newWidth+'px'});vid.on('loadedmetadata',FLBuilderLayout._resizeOnLoadedMeta);}
else{if(newHeight<wrapHeight){newHeight=wrapHeight;newWidth=Math.round(vidWidth*wrapHeight/vidHeight);newLeft=-((newWidth-wrapWidth)/2);}
else{newTop=-((newHeight-wrapHeight)/2);}
vid.css({'left':newLeft+'px','top':newTop+'px','height':newHeight+'px','width':newWidth+'px'});}}
else if(iframe.length){if(typeof wrap.data('youtube')!=='undefined'){FLBuilderLayout._resizeYoutubeBgVideo.apply(this);}}},_resizeOnLoadedMeta:function(){var video=$(this),wrapHeight=video.parent().outerHeight(),wrapWidth=video.parent().outerWidth(),vidWidth=video[0].videoWidth,vidHeight=video[0].videoHeight,newHeight=Math.round(vidHeight*wrapWidth/vidWidth),newWidth=wrapWidth,newLeft=0,newTop=0;if(newHeight<wrapHeight){newHeight=wrapHeight;newWidth=Math.round(vidWidth*wrapHeight/vidHeight);newLeft=-((newWidth-wrapWidth)/2);}
else{newTop=-((newHeight-wrapHeight)/2);}
video.parent().data('width',vidWidth);video.parent().data('height',vidHeight);video.css({'left':newLeft+'px','top':newTop+'px','width':newWidth+'px','height':newHeight+'px'});},_resizeYoutubeBgVideo:function()
{var wrap=$(this),wrapWidth=wrap.outerWidth(),wrapHeight=wrap.outerHeight(),player=wrap.data('YTPlayer'),video=player?player.getIframe():null,aspectRatioSetting='16:9',aspectRatioArray=aspectRatioSetting.split(':'),aspectRatio=aspectRatioArray[0]/aspectRatioArray[1],ratioWidth=wrapWidth/aspectRatio,ratioHeight=wrapHeight*aspectRatio,isWidthFixed=wrapWidth/wrapHeight>aspectRatio,width=isWidthFixed?wrapWidth:ratioHeight,height=isWidthFixed?ratioWidth:wrapHeight;if(video){$(video).width(width).height(height);}},_initModuleAnimations:function()
{if(typeof jQuery.fn.waypoint!=='undefined'){$('.fl-animation').each(function(){var node=$(this),nodeTop=node.offset().top,winHeight=$(window).height(),bodyHeight=$('body').height(),waypoint=FLBuilderLayoutConfig.waypoint,offset='80%';if(typeof waypoint.offset!==undefined){offset=FLBuilderLayoutConfig.waypoint.offset+'%';}
if(bodyHeight-nodeTop<winHeight*0.2){offset='100%';}
node.waypoint({offset:offset,handler:FLBuilderLayout._doModuleAnimation});});}},_doModuleAnimation:function()
{var module='undefined'==typeof this.element?$(this):$(this.element),delay=parseFloat(module.data('animation-delay')),duration=parseFloat(module.data('animation-duration'));if(!isNaN(duration)){module.css('animation-duration',duration+'s');}
if(!isNaN(delay)&&delay>0){setTimeout(function(){module.addClass('fl-animated');},delay*1000);}else{setTimeout(function(){module.addClass('fl-animated');},1);}},_initHash:function()
{var hash=window.location.hash.replace('#','').split('/').shift(),element=null,tabs=null,responsiveLabel=null,tabIndex=null,label=null;if(''!==hash){try{element=$('#'+hash);if(element.length>0){if(element.hasClass('fl-accordion-item')){setTimeout(function(){element.find('.fl-accordion-button').trigger('click');},100);}
if(element.hasClass('fl-tabs-panel')){setTimeout(function(){tabs=element.closest('.fl-tabs');responsiveLabel=element.find('.fl-tabs-panel-label');tabIndex=responsiveLabel.data('index');label=tabs.find('.fl-tabs-labels .fl-tabs-label[data-index='+tabIndex+']');if(responsiveLabel.is(':visible')){responsiveLabel.trigger('click');}
else{label[0].click();FLBuilderLayout._scrollToElement(element);}},100);}}}
catch(e){}}},_initAnchorLinks:function()
{$('a').each(FLBuilderLayout._initAnchorLink);},_initAnchorLink:function()
{var link=$(this),href=link.attr('href'),loc=window.location,id=null,element=null;if('undefined'!=typeof href&&href.indexOf('#')>-1&&link.closest('svg').length<1){if(loc.pathname.replace(/^\//,'')==this.pathname.replace(/^\//,'')&&loc.hostname==this.hostname){try{id=href.split('#').pop();if(!id){return;}
element=$('#'+id);if(element.length>0){if(link.hasClass('fl-scroll-link')||element.hasClass('fl-row')||element.hasClass('fl-col')||element.hasClass('fl-module')){$(link).on('click',FLBuilderLayout._scrollToElementOnLinkClick);}
if(element.hasClass('fl-accordion-item')){$(link).on('click',FLBuilderLayout._scrollToAccordionOnLinkClick);}
if(element.hasClass('fl-tabs-panel')){$(link).on('click',FLBuilderLayout._scrollToTabOnLinkClick);}}}
catch(e){}}}},_scrollToElementOnLinkClick:function(e,callback)
{var element=$('#'+$(this).attr('href').split('#').pop());FLBuilderLayout._scrollToElement(element,callback);e.preventDefault();},_scrollToElement:function(element,callback)
{var config=FLBuilderLayoutConfig.anchorLinkAnimations,dest=0,win=$(window),doc=$(document);if(element.length>0){if(element.offset().top>doc.height()-win.height()){dest=doc.height()-win.height();}
else{dest=element.offset().top-config.offset;}
$('html, body').animate({scrollTop:dest},config.duration,config.easing,function(){if('undefined'!=typeof callback){callback();}
if(undefined!=element.attr('id')){if(history.pushState){history.pushState(null,null,'#'+element.attr('id'));}
else{window.location.hash=element.attr('id');}}});}},_scrollToAccordionOnLinkClick:function(e)
{var element=$('#'+$(this).attr('href').split('#').pop());if(element.length>0){var callback=function(){if(element){element.find('.fl-accordion-button').trigger('click');element=false;}};FLBuilderLayout._scrollToElementOnLinkClick.call(this,e,callback);}},_scrollToTabOnLinkClick:function(e)
{var element=$('#'+$(this).attr('href').split('#').pop()),tabs=null,label=null,responsiveLabel=null;if(element.length>0){tabs=element.closest('.fl-tabs');responsiveLabel=element.find('.fl-tabs-panel-label');tabIndex=responsiveLabel.data('index');label=tabs.find('.fl-tabs-labels .fl-tabs-label[data-index='+tabIndex+']');if(responsiveLabel.is(':visible')){var callback=function(){if(element){responsiveLabel.trigger('click');element=false;}};FLBuilderLayout._scrollToElementOnLinkClick.call(this,e,callback);}
else{label[0].click();FLBuilderLayout._scrollToElement(element);}
e.preventDefault();}},_initForms:function()
{if(!FLBuilderLayout._hasPlaceholderSupport){$('.fl-form-field input').each(FLBuilderLayout._initFormFieldPlaceholderFallback);}
$('.fl-form-field input').on('focus',FLBuilderLayout._clearFormFieldError);},_hasPlaceholderSupport:function()
{var input=document.createElement('input');return'undefined'!=input.placeholder;},_initFormFieldPlaceholderFallback:function()
{var field=$(this),val=field.val(),placeholder=field.attr('placeholder');if('undefined'!=placeholder&&''===val){field.val(placeholder);field.on('focus',FLBuilderLayout._hideFormFieldPlaceholderFallback);field.on('blur',FLBuilderLayout._showFormFieldPlaceholderFallback);}},_hideFormFieldPlaceholderFallback:function()
{var field=$(this),val=field.val(),placeholder=field.attr('placeholder');if(val==placeholder){field.val('');}},_showFormFieldPlaceholderFallback:function()
{var field=$(this),val=field.val(),placeholder=field.attr('placeholder');if(''===val){field.val(placeholder);}},_clearFormFieldError:function()
{var field=$(this);field.removeClass('fl-form-error');field.siblings('.fl-form-error-message').hide();}};$(function(){FLBuilderLayout.init();});})(jQuery);(function($){UABBPhotoGallery=function(settings){this.settings=settings;this.node=settings.id;this.uabb_ajaxurl=settings.uabb_ajaxurl;this.nodeClass='.fl-node-'+settings.id;this.layout=settings.layout;this.pagination=settings.pagination;if('grid'===this.layout){this.wrapperClass=this.nodeClass+' .uabb-photo-gallery';this.itemClass=this.wrapperClass+' .uabb-photo-gallery-item';}else{this.wrapperClass=this.nodeClass+' .uabb-masonary-content';this.itemClass=this.wrapperClass+' .uabb-photo-item';}
_nonce=$(this.wrapperClass).data('nonce');this.cachedItems=false;this.cachedIds=[];this.isBuilderActive=settings.isBuilderActive;this.imgPerPage=settings.imgPerPage;this.total_img_count=settings.total_img_count;this._initFilter();if(this.pagination&&'none'!==this.pagination){this._initPagination();}};UABBPhotoGallery.prototype={settings:{},node:'',nodeClass:'',wrapperClass:'',itemClass:'',cachedItems:false,cachedIds:[],isBuilderActive:false,_initFilter:function(){if('grid'===this.layout){this._grid_layout();}else{this._masonary_layout();}},_grid_layout:function(){var nodeClass=jQuery(this.nodeClass);selector=nodeClass.find('.uabb-module-content');all_filters=selector.data('all-filters');var id=window.location.hash.substring(1);var pattern=new RegExp("^[\\w\\-]+$");var sanitize_input=pattern.test(id);if(selector.length<1){return;}
if(selector.hasClass('uabb-photo-gallery-filter-grid')){var filters=nodeClass.find('.uabb-photo__gallery-filters');var def_cat='*';if(''!==id&&sanitize_input){var select_filter=filters.find("[data-filter='"+'.'+id.toLowerCase()+"']");if(select_filter.length>0){def_cat='.'+id.toLowerCase();select_filter.siblings().removeClass('uabb-filter__current');select_filter.addClass('uabb-filter__current');}}
if(filters.length>0){var def_filter=filters.data('default');def_filter=def_filter.trim();if(''!==def_filter){def_cat=def_filter;def_cat_sel=filters.find('[data-filter="'+def_filter+'"]');if(0===def_cat_sel.length){return;}
if(def_cat_sel.length>0){def_cat_sel.siblings().removeClass('uabb-filter__current');def_cat_sel.addClass('uabb-filter__current');}
if(-1==all_filters.indexOf(def_cat.replace('.',""))){def_cat='*';}}}
var $obj={};nodeClass.find('.uabb-module-content').imagesLoaded({background:'.item'},function(e){$obj=nodeClass.find('.uabb-module-content').isotope({filter:def_cat,layoutMode:'fitRows',itemSelector:'.uabb-photo-item-grid',});nodeClass.find('.uabb-module-content').find('.uabb-photo-item-grid').resize(function(){$obj.isotope('layout');});});nodeClass.find('.uabb-photo__gallery-filter').on('click',function(){$(this).siblings().removeClass('uabb-filter__current');$(this).addClass('uabb-filter__current');var value=$(this).data('filter');nodeClass.find('.uabb-module-content').isotope({filter:value});});}},_masonary_layout:function(){var nodeClass=jQuery(this.nodeClass);selector=nodeClass.find('.uabb-masonary-content');all_filters=selector.data('all-filters');var id=window.location.hash.substring(1);var pattern=new RegExp("^[\\w\\-]+$");var sanitize_input=pattern.test(id);if(selector.length<1){return;}
if(selector.hasClass('uabb-photo-gallery-filter')){var filters=nodeClass.find('.uabb-photo__gallery-filters');var def_cat='*';if(''!==id&&sanitize_input){var select_filter=filters.find("[data-filter='"+'.'+id.toLowerCase()+"']");if(select_filter.length>0){def_cat='.'+id.toLowerCase();select_filter.siblings().removeClass('uabb-filter__current');select_filter.addClass('uabb-filter__current');}}
if(filters.length>0){var def_filter=filters.data('default');def_filter=def_filter.trim();if(''!==def_filter){def_cat=def_filter;def_cat_sel=filters.find('[data-filter="'+def_filter+'"]');if(0===def_cat_sel.length){return;}
if(def_cat_sel.length>0){def_cat_sel.siblings().removeClass('uabb-filter__current');def_cat_sel.addClass('uabb-filter__current');}
if(-1==all_filters.indexOf(def_cat.replace('.',""))){def_cat='*';}}}
var $obj={};nodeClass.find('.uabb-masonary-content').imagesLoaded({background:'.item'},function(e){$obj=nodeClass.find('.uabb-masonary-content').isotope({filter:def_cat,layoutMode:'masonry',itemSelector:'.uabb-photo-item',});nodeClass.find('.uabb-masonary-content').find('.uabb-photo-item').resize(function(){$obj.isotope('layout');});});nodeClass.find('.uabb-photo__gallery-filter').on('click',function(){$(this).siblings().removeClass('uabb-filter__current');$(this).addClass('uabb-filter__current');var value=$(this).data('filter');nodeClass.find('.uabb-masonary-content').isotope({filter:value});});}},_initPagination:function()
{var self=this;$(this.itemClass).each(function(){self.cachedIds.push($(this).data('item-id'));});if('masonary'===this.settings.layout){var wrap=$(this.wrapperClass);var isotopeData={layoutMode:'masonry',itemSelector:'.uabb-photo-item',};wrap.imagesLoaded($.proxy(function(){wrap.isotope(isotopeData);},this));}
if('load_more'===this.settings.pagination){this._initLoadMore();}
if('scroll'===this.settings.pagination&&!this.isBuilderActive){this._initScroll();}},_initLoadMore:function()
{var self=this;$(this.nodeClass).find('.uabb-gallery-load-more').on('click',function(e){e.preventDefault();var $this=$(this);$this.addClass('disabled loading');$this.append('<span class="uabb-form-loader"></span>');if(self.cachedItems){self._renderItems();}else{self._getAjaxPhotos();}});},_initScroll:function(){var self=this,galleryOffset=$(this.wrapperClass).offset(),galleryHeight=$(this.wrapperClass).height(),winHeight=$(window).height(),loaded=false;$(window).on('scroll',function(){if(loaded){return;}
var scrollPos=$(window).scrollTop();if(scrollPos>=galleryOffset.top-(winHeight-galleryHeight)){if($(self.nodeClass).find('.uabb-gallery-pagination.loaded').length>0){loaded=true;$(self.nodeClass).find('.uabb-gallery-loader').hide();}else{loaded=true;$(self.wrapperClass).imagesLoaded(function(){setTimeout(function(){if(self.cachedItems){self._renderItems();galleryHeight=$(self.wrapperClass).height();}else{self._getAjaxPhotos(function(){galleryHeight=$(self.wrapperClass).height();});}},600);});}}});$(this.wrapperClass).on('gallery.rendered',function(){if($(self.nodeClass).find('.uabb-gallery-pagination.loaded').length===0){loaded=false;galleryHeight=$(self.wrapperClass).height();}});},_getAjaxPhotos:function(callback){var self=this;var _nonce=$(self.wrapperClass).data('nonce');var ajaxurl=this.uabb_ajaxurl;var data={action:'uabb_get_photos',node_id:self.settings.id,images_per_page:self.settings.imgPerPage,settings:self.settings.settings,security:_nonce};$(this.nodeClass).find('.uabb-gallery-loader').show();$.ajax({type:'post',url:ajaxurl,data:data,dataType:'json',async:true,success:function(response){response=JSON.parse(JSON.stringify(response));self.cachedItems=response.data;self._renderItems();if('function'===typeof callback){callback();}
$(self.nodeClass).find('.uabb-gallery-loader').hide();}});},_renderItems:function()
{$(this.nodeClass).find('.uabb-form-loader').remove();$(this.nodeClass).find('.uabb-gallery-load-more').removeClass('disabled loading');$(this.nodeClass).find('.uabb-gallery-loader').show();var self=this,wrap=$(self.wrapperClass);if(self.cachedItems){var count=1;var items=[];$(self.cachedItems).each(function(){var id=$(this).data('item-id');if(-1===$.inArray(id,self.cachedIds)&&undefined!==id){if(count<=self.imgPerPage){self.cachedIds.push(id);items.push(this);count++;}}});if(items.length>0){items=$(items).hide();if(self.layout==='grid'){wrap.append(items.fadeIn());}
if(self.layout==='masonary'){items=items.show();wrap.isotope('insert',items);wrap.imagesLoaded($.proxy(function(){setTimeout(function(){wrap.isotope('layout');},500);},this));}
wrap.trigger('gallery.rendered');}
if(self.total_img_count===self.cachedIds.length){$(self.nodeClass).find('.uabb-gallery-pagination').addClass('loaded').hide();$(self.nodeClass).find('.uabb-gallery-loader').hide();}}}};})(jQuery);jQuery(document).ready(function(){new UABBPhotoGallery({id:'5c45bb34b13b2',uabb_ajaxurl:"https://fenixingenieria.es/wp-admin/admin-ajax.php",layout:'grid',pagination:'none',isBuilderActive:false,imgPerPage:6,settings:{"layout":"grid","photos":[922,927,883,935,934,899,930,923,900,884,880,885,901,908,877,902,903,905,906,887,879,907,909,904,910,912,911,892,926,913,914,915,924,916,874,925,918,919,889,894,933,897,920,882],"photo_size":"medium","photo_spacing":"30","photo_spacing_medium":"","photo_spacing_responsive":"","photo_order":"normal","grid_column":"5","medium_grid_column":"5","responsive_grid_column":"2","show_captions":"0","click_action":"none","click_action_target":"_blank","filterable_gallery_enable":"yes","filters_all_text":"Todos","default_filter_switch":"no","default_filter":"Alimentaci\u00f3n","show_filter_title":"no","filters_heading_text":"","pagination":"none","images_per_page":"6","load_more_text":"Load More","hover_effects":"none","overlay_color":"rgba(255,0,0,0)","icon":"0","overlay_icon":"","overlay_icon_size":"","overlay_icon_color":"","img_drop_shadow":"no","img_shadow_color_hor":"0","img_shadow_color_ver":"0","img_shadow_color_blur":"7","img_shadow_color_spr":"0","img_shadow_color":"rgba(168,168,168,0.5)","img_hover_shadow":"no","img_shadow_color_hor_hover":"0","img_shadow_color_ver_hover":"0","img_shadow_color_blur_hover":"10","img_shadow_color_spr_hover":"1","img_shadow_color_hover":"rgba(168,168,168,0.9)","img_shadow_hover_transition":"200","cat_filter_align":"center","cat_filter_bet_spacing":"","cat_filter_bet_spacing_medium":"","cat_filter_bet_spacing_responsive":"","cat_filter_spacing":"","cat_filter_spacing_medium":"","cat_filter_spacing_responsive":"","cat_filter_color":"","cat_filter_hover_color":"","cat_filter_bg_color":"","cat_filter_bg_hover_color":"dd9933","cat_filter_border":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"cat_filter_border_medium":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"cat_filter_border_responsive":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"cat_filter_border_hover_color":"","filter_title_color":"","filters_tab_heading_stack":"mobile","load_more_bg_color":"#eee","load_more_bg_hover_color":"","load_more_text_color":"","load_more_text_hover_color":"","load_more_border":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"load_more_border_medium":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"load_more_border_responsive":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"border_hover_color":"","load_more_margin_top":"30","load_more_align":"center","tag_selection":"h3","caption_font_typo":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"caption_font_typo_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"caption_font_typo_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"color":"","caption_bg_color":"","cat_font_typo":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"cat_font_typo_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"cat_font_typo_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"load_more_typo":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"load_more_typo_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"load_more_typo_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"filter_title_tag":"h3","filter_font_typo":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"filter_font_typo_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"filter_font_typo_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"uabb_helpful_information":"","responsive_display":"","visibility_display":"","visibility_user_capability":"","animation":{"style":"","delay":"0","duration":"1"},"container_element":"div","id":"","class":"","export":"","import":"","cat_filter_padding_top":"","cat_filter_padding_top_medium":"","cat_filter_padding_top_responsive":"","cat_filter_padding_right":"","cat_filter_padding_right_medium":"","cat_filter_padding_right_responsive":"","cat_filter_padding_bottom":"","cat_filter_padding_bottom_medium":"","cat_filter_padding_bottom_responsive":"","cat_filter_padding_left":"","cat_filter_padding_left_medium":"","cat_filter_padding_left_responsive":"","load_more_padding_top":"10","load_more_padding_top_medium":"","load_more_padding_top_responsive":"","load_more_padding_right":"10","load_more_padding_right_medium":"","load_more_padding_right_responsive":"","load_more_padding_bottom":"10","load_more_padding_bottom_medium":"","load_more_padding_bottom_responsive":"","load_more_padding_left":"10","load_more_padding_left_medium":"","load_more_padding_left_responsive":"","margin_top":"0","margin_unit":"px","margin_top_medium":"","margin_medium_unit":"px","margin_top_responsive":"0","margin_responsive_unit":"px","margin_right":"0","margin_right_medium":"","margin_right_responsive":"0","margin_bottom":"0","margin_bottom_medium":"","margin_bottom_responsive":"0","margin_left":"0","margin_left_medium":"","margin_left_responsive":"0","type":"photo-gallery","photo_data":{"922":{"id":922,"alt":"","caption":"","description":"","title":"airesdejaen","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/airesdejaen-1-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/airesdejaen-1.png","cta_link":"","category":"Alimentaci\u00f3n"},"927":{"id":927,"alt":"","caption":"","description":"","title":"aos","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/aos-1-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/aos-1.png","cta_link":"","category":"Industrial"},"883":{"id":883,"alt":"","caption":"","description":"","title":"apc","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/apc-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/apc.png","cta_link":"","category":"Industrial"},"935":{"id":935,"alt":"","caption":"","description":"","title":"atroca","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/atroca-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/atroca.png","cta_link":"","category":"Alimentaci\u00f3n"},"934":{"id":934,"alt":"","caption":"","description":"","title":"brenntag","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/brenntag-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/brenntag.png","cta_link":"","category":"Qu\u00edmico"},"899":{"id":899,"alt":"","caption":"","description":"","title":"artealca","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/artealca-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/artealca.png","cta_link":"","category":"Alimentaci\u00f3n"},"930":{"id":930,"alt":"","caption":"","description":"","title":"avancecarton","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/avancecarton-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/avancecarton.png","cta_link":"","category":"Industrial"},"923":{"id":923,"alt":"","caption":"","description":"","title":"biomedal","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/biomedal-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/biomedal.png","cta_link":"","category":"Farmac\u00e9utico"},"900":{"id":900,"alt":"","caption":"","description":"","title":"campofrio","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/campofrio-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/campofrio.png","cta_link":"","category":"Alimentaci\u00f3n"},"884":{"id":884,"alt":"","caption":"","description":"","title":"canopack","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/canopack-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/canopack.png","cta_link":"","category":"Industrial"},"880":{"id":880,"alt":"","caption":"","description":"","title":"carbo","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/carbo-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/carbo.png","cta_link":"","category":"Log\u00edstica"},"885":{"id":885,"alt":"","caption":"","description":"","title":"cartonajesgisbert","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/cartonajesgisbert-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/cartonajesgisbert.png","cta_link":"","category":"Industrial"},"901":{"id":901,"alt":"","caption":"","description":"","title":"clazamar","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/clazamar-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/clazamar.png","cta_link":"","category":"Alimentaci\u00f3n"},"908":{"id":908,"alt":"","caption":"","description":"","title":"costafood","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/costafood-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/costafood.png","cta_link":"","category":"Alimentaci\u00f3n"},"877":{"id":877,"alt":"","caption":"","description":"","title":"deretil","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/deretil-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/deretil.png","cta_link":"","category":"Qu\u00edmico"},"902":{"id":902,"alt":"","caption":"","description":"","title":"dulcinea","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/dulcinea-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/dulcinea.png","cta_link":"","category":"Alimentaci\u00f3n"},"903":{"id":903,"alt":"","caption":"","description":"","title":"ebro","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/ebro-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/ebro.png","cta_link":"","category":"Alimentaci\u00f3n"},"905":{"id":905,"alt":"","caption":"","description":"","title":"embumar","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/embumar-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/embumar.png","cta_link":"","category":"Alimentaci\u00f3n"},"906":{"id":906,"alt":"","caption":"","description":"","title":"feysol","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/feysol-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/feysol.png","cta_link":"","category":"Alimentaci\u00f3n"},"887":{"id":887,"alt":"","caption":"","description":"","title":"finsa","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/finsa-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/finsa.png","cta_link":"","category":"Industrial"},"879":{"id":879,"alt":"","caption":"","description":"","title":"fosterfood","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/fosterfood-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/fosterfood.png","cta_link":"","category":"Log\u00edstica"},"907":{"id":907,"alt":"","caption":"","description":"","title":"frimancha","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/frimancha-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/frimancha.png","cta_link":"","category":"Alimentaci\u00f3n"},"909":{"id":909,"alt":"","caption":"","description":"","title":"herba","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/herba-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/herba.png","cta_link":"","category":"Alimentaci\u00f3n"},"904":{"id":904,"alt":"","caption":"","description":"","title":"elmaquina","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/elmaquina-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/elmaquina.png","cta_link":"","category":"Alimentaci\u00f3n"},"910":{"id":910,"alt":"","caption":"","description":"","title":"ibercacao","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/ibercacao-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/ibercacao.png","cta_link":"","category":"Alimentaci\u00f3n"},"912":{"id":912,"alt":"","caption":"","description":"","title":"incarlopsa","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/incarlopsa-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/incarlopsa.png","cta_link":"","category":"Alimentaci\u00f3n"},"911":{"id":911,"alt":"","caption":"","description":"","title":"ibervalue","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/ibervalue-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/ibervalue.png","cta_link":"","category":"Alimentaci\u00f3n"},"892":{"id":892,"alt":"","caption":"","description":"","title":"internationalpaper","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/internationalpaper-1-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/internationalpaper-1.png","cta_link":"","category":"Industrial"},"926":{"id":926,"alt":"","caption":"","description":"","title":"klinea","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/klinea-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/klinea.png","cta_link":"","category":"Farmac\u00e9utico"},"913":{"id":913,"alt":"","caption":"","description":"","title":"lacomarca","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/lacomarca-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/lacomarca.png","cta_link":"","category":"Alimentaci\u00f3n"},"914":{"id":914,"alt":"","caption":"","description":"","title":"madripan","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/madripan-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/madripan.png","cta_link":"","category":"Alimentaci\u00f3n"},"915":{"id":915,"alt":"","caption":"","description":"","title":"malvon","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/malvon-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/malvon.png","cta_link":"","category":"Alimentaci\u00f3n"},"924":{"id":924,"alt":"","caption":"","description":"","title":"mifco","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/mifco-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/mifco.png","cta_link":"","category":"Farmac\u00e9utico"},"916":{"id":916,"alt":"","caption":"","description":"","title":"orobailen","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/orobailen-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/orobailen.png","cta_link":"","category":"Alimentaci\u00f3n"},"874":{"id":874,"alt":"","caption":"","description":"","title":"persan","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/persan-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/persan.png","cta_link":"","category":"Qu\u00edmico"},"925":{"id":925,"alt":"","caption":"","description":"","title":"pharmex","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/pharmex-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/pharmex.png","cta_link":"","category":"Farmac\u00e9utico"},"918":{"id":918,"alt":"","caption":"","description":"","title":"refresco","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/refresco-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/refresco.png","cta_link":"","category":"Alimentaci\u00f3n"},"919":{"id":919,"alt":"","caption":"","description":"","title":"saar","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/saar-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/saar.png","cta_link":"","category":"Alimentaci\u00f3n"},"889":{"id":889,"alt":"","caption":"","description":"","title":"spgroup","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/spgroup-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/spgroup.png","cta_link":"","category":"Industrial"},"894":{"id":894,"alt":"","caption":"","description":"","title":"tradecorp","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/tradecorp-1-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/tradecorp-1.png","cta_link":"","category":"Qu\u00edmico"},"933":{"id":933,"alt":"","caption":"","description":"","title":"unide","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/unide-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/unide.png","cta_link":"","category":"Log\u00edstica"},"897":{"id":897,"alt":"","caption":"","description":"","title":"villar","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/villar-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/villar.png","cta_link":"","category":"Alimentaci\u00f3n"},"920":{"id":920,"alt":"","caption":"","description":"","title":"williamshumbert","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/williamshumbert-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/williamshumbert.png","cta_link":"","category":"Alimentaci\u00f3n"},"882":{"id":882,"alt":"","caption":"","description":"","title":"xilonor","src":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/xilonor-300x300.png","link":"https:\/\/fenixingenieria.es\/wp-content\/uploads\/2021\/02\/xilonor.png","cta_link":"","category":"Industrial"}}},total_img_count:44,});});jQuery(document).ready(function($){$(function(){$('.fl-node-5c45bb34b13b2 .uabb-gallery-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});});jQuery(function($){$(function(){$('.fl-node-5c6a9f5ee9770 .uabb-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});});(function($){var arrObj=new Array();jQuery('.fl-node-5dfcb0be9dc6a .uabb-slider-next').empty();jQuery('.fl-node-5dfcb0be9dc6a .uabb-slider-prev').empty();var testimonial_5dfcb0be9dc6a=jQuery('.fl-node-5dfcb0be9dc6a .uabb-testimonials').bxSlider({autoStart:0,auto:true,adaptiveHeight:false,pause:10000,mode:'horizontal',speed:500,pager:1,nextSelector:'.fl-node-5dfcb0be9dc6a .uabb-slider-next',prevSelector:'.fl-node-5dfcb0be9dc6a .uabb-slider-prev',nextText:'<i class="fa fa-chevron-right"></i>',prevText:'<i class="fa fa-chevron-left"></i>',controls:0,onSliderLoad:function(){jQuery('.fl-node-5dfcb0be9dc6a .uabb-testimonials').addClass('uabb-testimonials-loaded');}});arrObj['testimonial_5dfcb0be9dc6a']=testimonial_5dfcb0be9dc6a;UABBTrigger.addHook('uabb-modal-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){testimonial_5dfcb0be9dc6a.reloadSlider();},250);}});UABBTrigger.addHook('uabb-accordion-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){var child_id=jQuery(selector).find('.fl-module-adv-testimonials').data('node');if(child_id!==null&&arrObj['testimonial_'+child_id]!==undefined){arrObj['testimonial_'+child_id].reloadSlider();}},250);}});UABBTrigger.addHook('uabb-tab-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){var child_id=jQuery(selector).find('.fl-module-adv-testimonials').data('node');if(child_id!==null&&arrObj['testimonial_'+child_id]!==undefined){arrObj['testimonial_'+child_id].reloadSlider();}},250);}});jQuery(window).load(function(){testimonial_5dfcb0be9dc6a.reloadSlider();});})(jQuery);jQuery(function($){$(function(){$('.fl-node-5c6a9fbc69eb5 .uabb-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});});(function($){var arrObj=new Array();jQuery('.fl-node-5dfcb0f0dd429 .uabb-slider-next').empty();jQuery('.fl-node-5dfcb0f0dd429 .uabb-slider-prev').empty();var testimonial_5dfcb0f0dd429=jQuery('.fl-node-5dfcb0f0dd429 .uabb-testimonials').bxSlider({autoStart:0,auto:true,adaptiveHeight:false,pause:10000,mode:'horizontal',speed:500,pager:1,nextSelector:'.fl-node-5dfcb0f0dd429 .uabb-slider-next',prevSelector:'.fl-node-5dfcb0f0dd429 .uabb-slider-prev',nextText:'<i class="fa fa-chevron-right"></i>',prevText:'<i class="fa fa-chevron-left"></i>',controls:0,onSliderLoad:function(){jQuery('.fl-node-5dfcb0f0dd429 .uabb-testimonials').addClass('uabb-testimonials-loaded');}});arrObj['testimonial_5dfcb0f0dd429']=testimonial_5dfcb0f0dd429;UABBTrigger.addHook('uabb-modal-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){testimonial_5dfcb0f0dd429.reloadSlider();},250);}});UABBTrigger.addHook('uabb-accordion-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){var child_id=jQuery(selector).find('.fl-module-adv-testimonials').data('node');if(child_id!==null&&arrObj['testimonial_'+child_id]!==undefined){arrObj['testimonial_'+child_id].reloadSlider();}},250);}});UABBTrigger.addHook('uabb-tab-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){var child_id=jQuery(selector).find('.fl-module-adv-testimonials').data('node');if(child_id!==null&&arrObj['testimonial_'+child_id]!==undefined){arrObj['testimonial_'+child_id].reloadSlider();}},250);}});jQuery(window).load(function(){testimonial_5dfcb0f0dd429.reloadSlider();});})(jQuery);jQuery(function($){$(function(){$('.fl-node-5c6a9f5ee981d .uabb-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});});(function($){var arrObj=new Array();jQuery('.fl-node-5dfcb01d2599a .uabb-slider-next').empty();jQuery('.fl-node-5dfcb01d2599a .uabb-slider-prev').empty();var testimonial_5dfcb01d2599a=jQuery('.fl-node-5dfcb01d2599a .uabb-testimonials').bxSlider({autoStart:0,auto:true,adaptiveHeight:false,pause:10000,mode:'horizontal',speed:500,pager:1,nextSelector:'.fl-node-5dfcb01d2599a .uabb-slider-next',prevSelector:'.fl-node-5dfcb01d2599a .uabb-slider-prev',nextText:'<i class="fa fa-chevron-right"></i>',prevText:'<i class="fa fa-chevron-left"></i>',controls:0,onSliderLoad:function(){jQuery('.fl-node-5dfcb01d2599a .uabb-testimonials').addClass('uabb-testimonials-loaded');}});arrObj['testimonial_5dfcb01d2599a']=testimonial_5dfcb01d2599a;UABBTrigger.addHook('uabb-modal-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){testimonial_5dfcb01d2599a.reloadSlider();},250);}});UABBTrigger.addHook('uabb-accordion-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){var child_id=jQuery(selector).find('.fl-module-adv-testimonials').data('node');if(child_id!==null&&arrObj['testimonial_'+child_id]!==undefined){arrObj['testimonial_'+child_id].reloadSlider();}},250);}});UABBTrigger.addHook('uabb-tab-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){var child_id=jQuery(selector).find('.fl-module-adv-testimonials').data('node');if(child_id!==null&&arrObj['testimonial_'+child_id]!==undefined){arrObj['testimonial_'+child_id].reloadSlider();}},250);}});jQuery(window).load(function(){testimonial_5dfcb01d2599a.reloadSlider();});})(jQuery);jQuery(function($){$(function(){$('.fl-node-5c6a9f5ee98cb .uabb-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});});(function($){var arrObj=new Array();jQuery('.fl-node-5dfcb0dae2279 .uabb-slider-next').empty();jQuery('.fl-node-5dfcb0dae2279 .uabb-slider-prev').empty();var testimonial_5dfcb0dae2279=jQuery('.fl-node-5dfcb0dae2279 .uabb-testimonials').bxSlider({autoStart:0,auto:true,adaptiveHeight:false,pause:10000,mode:'horizontal',speed:500,pager:1,nextSelector:'.fl-node-5dfcb0dae2279 .uabb-slider-next',prevSelector:'.fl-node-5dfcb0dae2279 .uabb-slider-prev',nextText:'<i class="fa fa-chevron-right"></i>',prevText:'<i class="fa fa-chevron-left"></i>',controls:0,onSliderLoad:function(){jQuery('.fl-node-5dfcb0dae2279 .uabb-testimonials').addClass('uabb-testimonials-loaded');}});arrObj['testimonial_5dfcb0dae2279']=testimonial_5dfcb0dae2279;UABBTrigger.addHook('uabb-modal-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){testimonial_5dfcb0dae2279.reloadSlider();},250);}});UABBTrigger.addHook('uabb-accordion-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){var child_id=jQuery(selector).find('.fl-module-adv-testimonials').data('node');if(child_id!==null&&arrObj['testimonial_'+child_id]!==undefined){arrObj['testimonial_'+child_id].reloadSlider();}},250);}});UABBTrigger.addHook('uabb-tab-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){var child_id=jQuery(selector).find('.fl-module-adv-testimonials').data('node');if(child_id!==null&&arrObj['testimonial_'+child_id]!==undefined){arrObj['testimonial_'+child_id].reloadSlider();}},250);}});jQuery(window).load(function(){testimonial_5dfcb0dae2279.reloadSlider();});})(jQuery);jQuery(function($){$(function(){$('.fl-node-5c6a9f9b9b262 .uabb-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});});(function($){var arrObj=new Array();jQuery('.fl-node-5dfcb10fb8a10 .uabb-slider-next').empty();jQuery('.fl-node-5dfcb10fb8a10 .uabb-slider-prev').empty();var testimonial_5dfcb10fb8a10=jQuery('.fl-node-5dfcb10fb8a10 .uabb-testimonials').bxSlider({autoStart:0,auto:true,adaptiveHeight:false,pause:10000,mode:'horizontal',speed:500,pager:1,nextSelector:'.fl-node-5dfcb10fb8a10 .uabb-slider-next',prevSelector:'.fl-node-5dfcb10fb8a10 .uabb-slider-prev',nextText:'<i class="fa fa-chevron-right"></i>',prevText:'<i class="fa fa-chevron-left"></i>',controls:0,onSliderLoad:function(){jQuery('.fl-node-5dfcb10fb8a10 .uabb-testimonials').addClass('uabb-testimonials-loaded');}});arrObj['testimonial_5dfcb10fb8a10']=testimonial_5dfcb10fb8a10;UABBTrigger.addHook('uabb-modal-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){testimonial_5dfcb10fb8a10.reloadSlider();},250);}});UABBTrigger.addHook('uabb-accordion-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){var child_id=jQuery(selector).find('.fl-module-adv-testimonials').data('node');if(child_id!==null&&arrObj['testimonial_'+child_id]!==undefined){arrObj['testimonial_'+child_id].reloadSlider();}},250);}});UABBTrigger.addHook('uabb-tab-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){var child_id=jQuery(selector).find('.fl-module-adv-testimonials').data('node');if(child_id!==null&&arrObj['testimonial_'+child_id]!==undefined){arrObj['testimonial_'+child_id].reloadSlider();}},250);}});jQuery(window).load(function(){testimonial_5dfcb10fb8a10.reloadSlider();});})(jQuery);